<?php
function custom_checkout_form_styles() {
    // 1. جلب الألوان مع قيم افتراضية قوية (لتجنب الاختفاء)
    $button_bg_color    = get_option('amcod_button_bg_color') ?: '#654ad1';
    $button_text_color  = get_option('amcod_button_text_color') ?: '#ffffff';
    $button_hover_color = get_option('amcod_button_hover_color') ?: '#523c9e';
    
    $form_bg_color      = get_option('amcod_form_bg_color') ?: '#ffffff';
    // لون العناوين: إذا لم يكن محفوظاً، اجعله أسود غامق
    $headings_color     = get_option('amcod_headings_color') ?: '#222222'; 
    
    $input_bg_color     = get_option('amcod_input_bg_color') ?: '#f9f9f9';
    $input_border_color = get_option('amcod_input_border_color') ?: '#dddddd';
    
    // الاتجاهات
    $order_review_direction   = get_option('amcod_order_review_direction', 'rtl');
    $text_align               = get_option('amcod_text_align', 'right');
    $fields_direction         = get_option('amcod_fields_direction', 'rtl');
    ?>
    <style>
        /* =========================================
           1. تنسيقات عامة
           ========================================= */
        html, body {
            font-family: 'Cairo', sans-serif !important;
        }

        #custom-checkout-form {
            background: <?php echo esc_attr($form_bg_color); ?>;
            border: 1px solid <?php echo esc_attr($input_border_color); ?>;
            width: 100%;
            max-width: 600px;
            margin: 30px auto;
            padding: 25px;
            border-radius: 12px;
            box-shadow: 0 5px 20px rgba(0, 0, 0, 0.05);
            direction: <?php echo $fields_direction; ?>;
            text-align: <?php echo $text_align; ?>;
            font-family: 'Cairo', sans-serif;
            box-sizing: border-box;
        }
        
        /* تطبيق لون النصوص */
        #custom-checkout-form h3, 
        #shipping-methods-container h5,
        .attribute-label strong,
        .order-review h3,
        .animated-text-info,
        .item-label,
        .item-value,
        #shipping-cost {
            color: <?php echo esc_attr($headings_color); ?> !important;
        }

        /* =========================================
           2. الحقول والإدخالات
           ========================================= */
        #custom-checkout-form .field-container {
            margin-bottom: 15px;
            position: relative;
        }

        #custom-checkout-form input[type="text"],
        #custom-checkout-form input[type="email"],
        #custom-checkout-form input[type="tel"],
        #custom-checkout-form input[type="number"],
        #custom-checkout-form select,
        #custom-checkout-form textarea {
            width: 100%;
            height: 48px;
            padding: 0 15px;
            border: 1px solid <?php echo esc_attr($input_border_color); ?>;
            border-radius: 8px;
            font-size: 14px;
            background: <?php echo esc_attr($input_bg_color); ?>;
            color: <?php echo esc_attr($headings_color); ?>;
            transition: all 0.3s ease;
            box-sizing: border-box;
            font-family: 'Cairo', sans-serif;
            outline: none;
            text-align: <?php echo $text_align; ?> !important;
            direction: <?php echo $fields_direction; ?> !important;
        }

        /* إصلاح رقم الهاتف */
        #custom-checkout-form input[type="tel"] {
            text-align: <?php echo $text_align; ?> !important;
            direction: <?php echo $fields_direction; ?> !important;
        }
        #custom-checkout-form input[type="tel"]::placeholder {
            text-align: <?php echo $text_align; ?> !important;
            direction: <?php echo $fields_direction; ?> !important;
        }

        #custom-checkout-form textarea { height: auto; padding-top: 10px; min-height: 80px; }

        #custom-checkout-form input:focus,
        #custom-checkout-form select:focus {
            border-color: <?php echo $button_bg_color; ?>;
            background: #fff;
            box-shadow: 0 0 0 2px <?php echo $button_bg_color; ?>33;
        }

        #custom-checkout-form table { width: 100%; border-collapse: separate; border-spacing: 0; }
        #custom-checkout-form td { padding: 0 5px; vertical-align: top; border: none; }

        /* =========================================
           3. خيارات الشحن
           ========================================= */
        #shipping-methods-container h5 { font-size: 16px; font-weight: 700; margin-bottom: 12px; }

        .variation-option {
            display: flex; align-items: center; justify-content: space-between;
            background: <?php echo esc_attr($input_bg_color); ?>;
            border: 1px solid <?php echo esc_attr($input_border_color); ?>;
            border-radius: 8px; padding: 12px 15px; margin-bottom: 10px;
            cursor: pointer; transition: all 0.2s;
        }
        .variation-option:hover { border-color: <?php echo $button_bg_color; ?>; background: #fff; }
        .variation-option input[type="radio"] { width: 18px !important; height: 18px !important; margin: 0 0 0 10px !important; accent-color: <?php echo $button_bg_color; ?>; }
        .variation-option label { width: 100%; cursor: pointer; display: flex; justify-content: space-between; font-weight: 600; font-size: 14px; color: <?php echo esc_attr($headings_color); ?>; }

        /* =========================================
           4. الكمية وزر الطلب
           ========================================= */
        .quantity-and-submit { display: flex; gap: 15px; align-items: center; margin-top: 20px; }
        
        .quantity-wrapper {
            display: flex; border: 1px solid <?php echo esc_attr($input_border_color); ?>;
            border-radius: 8px; overflow: hidden; height: 48px; min-width: 120px; align-items: center;
            background: <?php echo esc_attr($input_bg_color); ?>;
        }
        .quantity-wrapper button {
            background: rgba(0,0,0,0.05); border: none; width: 40px; height: 100%; font-size: 18px;
            cursor: pointer; color: <?php echo esc_attr($headings_color); ?>; transition: 0.2s;
            padding: 0; display: flex; align-items: center; justify-content: center;
        }
        .quantity-wrapper button:hover { background: rgba(0,0,0,0.1); }

        /* توسيط الرقم */
        #custom-checkout-form .quantity-wrapper input,
        #custom-checkout-form .quantity-wrapper input[type="number"] {
            text-align: center !important; border: none !important; font-weight: bold; font-size: 18px !important;
            width: 50px !important; background: transparent !important;
            color: <?php echo esc_attr($headings_color); ?> !important;
            padding: 0 !important; margin: 0 !important; height: 48px !important; 
            line-height: 48px !important; border-radius: 0 !important; -moz-appearance: textfield;
        }
        .quantity-wrapper input::-webkit-outer-spin-button, 
        .quantity-wrapper input::-webkit-inner-spin-button { -webkit-appearance: none; margin: 0; }

        #submit-button {
            flex-grow: 1; background-color: <?php echo $button_bg_color; ?>; color: <?php echo $button_text_color; ?>;
            border: none; border-radius: 8px; font-size: 16px; font-weight: 700; height: 48px;
            cursor: pointer; transition: background 0.3s, transform 0.2s; box-shadow: 0 4px 6px rgba(0,0,0,0.1);
        }
        #submit-button:hover { background-color: <?php echo $button_hover_color; ?>; transform: translateY(-1px); }

        /* =========================================
           5. ملخص الطلب (Order Review) - الحل الجذري
           ========================================= */
        .order-review {
            margin-top: 25px;
            border-top: 2px dashed <?php echo esc_attr($input_border_color); ?>;
            padding-top: 20px;
            background: rgba(0,0,0,0.02);
            border-radius: 10px;
            padding: 15px;
            text-align: <?php echo $text_align; ?>;
            direction: <?php echo $fields_direction; ?>;
        }

        .order-review h3 {
            font-size: 16px; font-weight: 800; margin: 0 0 15px 0;
            color: <?php echo esc_attr($headings_color); ?> !important;
            border-bottom: 1px solid <?php echo esc_attr($input_border_color); ?>;
            padding-bottom: 10px;
        }

        .order-summary { display: flex; flex-direction: column; gap: 10px; }

        .order-item {
            display: flex; justify-content: space-between; align-items: center;
            font-size: 14px; color: <?php echo esc_attr($headings_color); ?>;
        }

        .order-item .item-label { display: flex; align-items: center; gap: 8px; }
        .product-info { display: flex; align-items: center; gap: 8px; }

        #quantity-display {
            background-color: <?php echo $button_bg_color; ?>;
            color: <?php echo $button_text_color; ?>;
            font-size: 11px; font-weight: bold; padding: 2px 8px;
            border-radius: 12px; display: inline-block; line-height: 1.2;
        }

        .item-value {
            font-weight: 700;
            color: <?php echo esc_attr($headings_color); ?> !important;
            direction: ltr;
            display: inline-block;
            min-width: 10px; /* ضمان الحجز */
        }

        /* 🔥🔥 إصلاح الاختفاء: فرض الظهور واللون */
        #shipping-cost {
            font-size: 14px;
            font-weight: bold;
            color: <?php echo esc_attr($headings_color); ?> !important;
            opacity: 1 !important;
            visibility: visible !important;
            display: inline-block !important;
        }

        .order-item.total {
            margin-top: 10px; padding-top: 10px;
            border-top: 1px solid <?php echo esc_attr($input_border_color); ?>;
            font-size: 18px; color: <?php echo $button_bg_color; ?>;
        }
        .order-item.total .item-value { color: <?php echo $button_bg_color; ?>; }

        .free-shipping {
            color: #27ae60 !important; font-weight: bold; font-size: 12px;
            background: #eafaf1; padding: 2px 8px; border-radius: 4px;
        }

        /* =========================================
           6. متفرقات
           ========================================= */
        .whatsapp-order-button {
            display: flex !important; align-items: center; justify-content: center; width: 100%;
            margin-top: 15px; background-color: #25D366 !important; color: white !important;
            font-weight: bold; text-decoration: none; border-radius: 8px; height: 45px;
            font-size: 15px; box-shadow: 0 3px 6px rgba(37, 211, 102, 0.2);
        }
        .whatsapp-order-button:hover { background-color: #128C7E !important; }

        .woocommerce-notices-wrapper, .woocommerce-form-login-toggle, .woocommerce-form-coupon-toggle, #ship-to-different-address {
            display: none !important;
        }

        /* القفل */
        #custom-checkout-form.amcod-locked {
            opacity: 0.4; pointer-events: none; user-select: none; filter: grayscale(80%);
        }
        .amcod-admin-overlay {
            position: absolute; top: 0; left: 0; width: 100%; height: 100%; z-index: 100;
            display: flex; align-items: center; justify-content: center; pointer-events: none;
        }
        .amcod-overlay-content {
            background: rgba(255, 255, 255, 0.95); padding: 30px; border-radius: 12px;
            text-align: center; box-shadow: 0 10px 30px rgba(0,0,0,0.2); border: 2px solid #e74c3c;
            pointer-events: auto; width: 80%; max-width: 300px;
        }
        .amcod-overlay-content h3 { margin: 0 0 10px; color: #c0392b; font-size: 20px; font-family: 'Cairo', sans-serif; }
        .amcod-overlay-content p { color: #555; font-size: 14px; margin-bottom: 20px; font-family: 'Cairo', sans-serif; }
        .amcod-activate-btn {
            display: block; background: #e74c3c; color: #fff !important; text-decoration: none;
            padding: 10px 0; border-radius: 5px; font-weight: bold; transition: 0.3s; font-family: 'Cairo', sans-serif;
        }
        .amcod-activate-btn:hover { background: #c0392b; }

        @media (max-width: 768px) {
            #custom-checkout-form { padding: 15px; margin: 10px auto; }
            #custom-checkout-form td { display: block; width: 100% !important; padding: 0; }
            .quantity-and-submit { flex-direction: row; }
            #submit-button { font-size: 15px; }
        }
    </style>
    <?php
}
add_action('wp_head', 'custom_checkout_form_styles');
?>