<?php
/*
Plugin Name: AM COD Checkout
Description: إضافة الدفع عند الاستلام 
Version: 5.7
Author: 4m1n1gr0
*/

if (!defined('ABSPATH')) {
    exit;
}

define('AMCOD_PATH', plugin_dir_path(__FILE__));
define('AMCOD_URL', plugin_dir_url(__FILE__));

// تسجيل تاريخ بداية الفترة التجريبية
register_activation_hook(__FILE__, 'amcod_activate_trial');
function amcod_activate_trial() {
    if (!get_option('amcod_trial_start_date')) {
        update_option('amcod_trial_start_date', time());
    }
}
add_action('admin_init', function() {
    if (!get_option('amcod_trial_start_date')) {
        update_option('amcod_trial_start_date', time());
    }
});

// تحميل الملفات
require_once AMCOD_PATH . 'includes/license.php';
include_once AMCOD_PATH . 'includes/custom-checkout-form.php';
include_once AMCOD_PATH . 'includes/form-handler.php';
include_once AMCOD_PATH . 'includes/ajax-functions.php';
include_once AMCOD_PATH . 'includes/style.php';
include_once AMCOD_PATH . 'includes/states.php';
include_once AMCOD_PATH . 'includes/communes.php'; 
require_once AMCOD_PATH . 'update/security.php';

// =================================================
// دالة مساعدة لتنسيق لوحة التحكم (CSS موحد)
// =================================================
function amcod_admin_header_and_styles($title, $icon = 'dashicons-admin-generic', $desc = '') {
    ?>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@400;600;700&display=swap" rel="stylesheet">
    
    <style>
        .amcod-dashboard { font-family: 'Cairo', sans-serif; max-width: 1000px; margin: 20px auto; direction: rtl; }
        
        .amcod-header { 
            background: linear-gradient(135deg, #654ad1 0%, #8e44ad 100%); 
            color: white; 
            padding: 25px 30px; 
            border-radius: 12px; 
            margin-bottom: 30px; 
            box-shadow: 0 8px 20px rgba(101, 74, 209, 0.2); 
            display: flex; 
            justify-content: space-between; 
            align-items: center; 
        }
        .amcod-header h1 { color: white; margin: 0; font-size: 26px; font-weight: 700; font-family: 'Cairo', sans-serif; }
        .amcod-header p { font-size: 15px; opacity: 0.9; margin-top: 5px; font-family: 'Cairo', sans-serif; }
        
        .amcod-card { 
            background: white; 
            border-radius: 12px; 
            padding: 25px; 
            border: 1px solid #eaeaec; 
            box-shadow: 0 4px 10px rgba(0,0,0,0.02); 
            margin-bottom: 20px;
        }
        
        .amcod-card h3 { 
            margin-top: 0; 
            margin-bottom: 20px; 
            color: #2c3e50; 
            border-bottom: 1px solid #f0f0f1; 
            padding-bottom: 15px; 
            font-size: 18px; 
            font-weight: 700; 
        }

        .amcod-field { margin-bottom: 20px; display: flex; align-items: center; justify-content: space-between; gap: 20px; }
        .amcod-field label { font-weight: 600; color: #555; font-size: 15px; flex-shrink: 0; }
        
        .amcod-input-text, .amcod-input-number, .amcod-select, .amcod-textarea {
            width: 100%; max-width: 400px; padding: 10px 15px; border: 1px solid #ddd;
            border-radius: 8px; font-family: 'Cairo', sans-serif; font-size: 14px; background: #fdfdfd; transition: 0.3s;
        }
        .amcod-input-text:focus, .amcod-textarea:focus { border-color: #654ad1; background: #fff; outline: none; box-shadow: 0 0 0 2px rgba(101, 74, 209, 0.1); }

        .amcod-submit-btn { 
            background: #654ad1 !important; border-color: #654ad1 !important; font-size: 16px !important; padding: 10px 35px !important; 
            height: auto !important; border-radius: 8px !important; transition: 0.3s !important; 
            font-family: 'Cairo', sans-serif !important; font-weight: 700 !important; color: white !important; cursor: pointer;
            box-shadow: 0 4px 6px rgba(101, 74, 209, 0.2);
        }
        .amcod-submit-btn:hover { background: #523c9e !important; transform: translateY(-2px); }

        .amcod-checkbox-wrapper { display: flex; align-items: center; cursor: pointer; }
        .amcod-checkbox-wrapper input { margin-left: 10px; width: 20px; height: 20px; }

        .wp-picker-container { direction: ltr !important; }
        .wp-color-result { margin: 0 0 0 5px !important; border-radius: 6px; height: 32px; box-shadow: inset 0 0 0 1px rgba(0,0,0,0.1); }
    </style>

    <div class="amcod-dashboard">
        <div class="amcod-header">
            <div>
                <h1><?php echo esc_html($title); ?></h1>
                <?php if($desc): ?><p><?php echo esc_html($desc); ?></p><?php endif; ?>
            </div>
            <span class="dashicons <?php echo esc_attr($icon); ?>" style="font-size: 45px; width: 45px; height: 45px;"></span>
        </div>
    <?php
}

// =================================================
// 1. القوائم (Admin Menu)
// =================================================
add_action('admin_menu', 'amcod_settings_menu');
function amcod_settings_menu() {
    add_menu_page('AM COD Settings', 'AM COD Settings', 'manage_options', 'amcod-settings', 'amcod_settings_page', 'dashicons-cart', 50);

    add_submenu_page('amcod-settings', 'IP Blocking', 'IP Blocking', 'manage_options', 'amcod-ip-blocking', 'amcod_ip_blocking_page');
    add_submenu_page('amcod-settings', 'Order Limit Settings', 'Order Limit Settings', 'manage_options', 'amcod-order-limit-settings', 'amcod_order_limit_settings_page');
    add_submenu_page('amcod-settings', 'Add to Cart', 'Add to Cart', 'manage_options', 'amcod-add-to-cart', 'amcod_add_to_cart_page');
    add_submenu_page('amcod-settings', 'Disable Checkout', 'Disable Checkout', 'manage_options', 'amcod-disable-checkout-form', 'amcod_disable_checkout_form_page');
    add_submenu_page('amcod-settings', 'Language', 'Language', 'manage_options', 'amcod-language', 'amcod_language_page');
    add_submenu_page('amcod-settings', 'Checkout Animations', 'Checkout Animations', 'manage_options', 'amcod-checkout-animations', 'amcod_checkout_animations_page');
    add_submenu_page('amcod-settings', 'Field Editor', 'Field Editor', 'manage_options', 'amcod-field-editor', 'amcod_field_editor_page');
    add_submenu_page('amcod-settings', 'WhatsApp Button', 'WhatsApp Button', 'manage_options', 'amcod-whatsapp-button', 'amcod_whatsapp_button_page');
    add_submenu_page('amcod-settings', 'Variation Swatches', 'Variation Swatches', 'manage_options', 'amcod-variation-swatches', 'amcod_variation_swatches_page');
}

// =================================================
// 2. الصفحة الرئيسية (التصميم الجديد)
// =================================================
function amcod_settings_page() {
    if (isset($_POST['amcod_settings_submit'])) {
        update_option('amcod_button_bg_color', sanitize_hex_color($_POST['button_bg_color']));
        update_option('amcod_button_text_color', sanitize_hex_color($_POST['button_text_color']));
        update_option('amcod_button_hover_color', sanitize_hex_color($_POST['button_hover_color']));
        update_option('amcod_form_bg_color', sanitize_hex_color($_POST['form_bg_color']));
        update_option('amcod_headings_color', sanitize_hex_color($_POST['headings_color']));
        update_option('amcod_input_bg_color', sanitize_hex_color($_POST['input_bg_color']));
        update_option('amcod_input_border_color', sanitize_hex_color($_POST['input_border_color']));
        echo '<div class="notice notice-success is-dismissible"><p>✅ تم حفظ الإعدادات.</p></div>';
    }
    
    $btn_bg = get_option('amcod_button_bg_color', '#654ad1');
    $btn_text = get_option('amcod_button_text_color', '#ffffff');
    $btn_hover = get_option('amcod_button_hover_color', '#523c9e');
    $form_bg = get_option('amcod_form_bg_color', '#ffffff');
    $head_color = get_option('amcod_headings_color', '#333333');
    $input_bg = get_option('amcod_input_bg_color', '#f9f9f9');
    $input_border = get_option('amcod_input_border_color', '#dddddd');

    amcod_admin_header_and_styles('تخصيص المظهر', 'dashicons-art', 'تحكم في ألوان وتصميم نموذج الدفع');
    ?>
    <form method="post">
        <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 20px;">
            <div class="amcod-card">
                <h3>النموذج والعناوين</h3>
                <div class="amcod-field"><label>لون خلفية النموذج</label><input type="text" name="form_bg_color" value="<?php echo esc_attr($form_bg); ?>" class="color-picker"></div>
                <div class="amcod-field"><label>لون العناوين</label><input type="text" name="headings_color" value="<?php echo esc_attr($head_color); ?>" class="color-picker"></div>
            </div>
            <div class="amcod-card">
                <h3>أزرار الطلب</h3>
                <div class="amcod-field"><label>خلفية الزر</label><input type="text" name="button_bg_color" value="<?php echo esc_attr($btn_bg); ?>" class="color-picker"></div>
                <div class="amcod-field"><label>نص الزر</label><input type="text" name="button_text_color" value="<?php echo esc_attr($btn_text); ?>" class="color-picker"></div>
                <div class="amcod-field"><label>الزر (Hover)</label><input type="text" name="button_hover_color" value="<?php echo esc_attr($btn_hover); ?>" class="color-picker"></div>
            </div>
            <div class="amcod-card">
                <h3>حقول الإدخال</h3>
                <div class="amcod-field"><label>خلفية الحقل</label><input type="text" name="input_bg_color" value="<?php echo esc_attr($input_bg); ?>" class="color-picker"></div>
                <div class="amcod-field"><label>لون الحدود</label><input type="text" name="input_border_color" value="<?php echo esc_attr($input_border); ?>" class="color-picker"></div>
            </div>
        </div>
        <div style="margin-top: 30px; text-align: left;">
            <input type="submit" name="amcod_settings_submit" class="button amcod-submit-btn" value="حفظ التغييرات">
        </div>
    </form>
    </div>
    <script>jQuery(document).ready(function($){ $('.color-picker').wpColorPicker(); });</script>
    <?php
}

// =================================================
// 3. الصفحات الفرعية
// =================================================

// --- صفحة IP Blocking ---
function amcod_ip_blocking_page() {
    if (isset($_POST['block_ip'])) {
        $blocked = get_option('amcod_blocked_ips', []);
        $blocked[$_POST['block_ip_address']] = time() + (intval($_POST['block_duration']) * 3600);
        update_option('amcod_blocked_ips', $blocked);
        echo '<div class="notice notice-success is-dismissible"><p>✅ تم حظر عنوان IP بنجاح.</p></div>';
    }
    
    amcod_admin_header_and_styles('حظر المستخدمين (IP)', 'dashicons-shield', 'منع عناوين IP محددة من الطلب');
    ?>
    <form method="post">
        <div class="amcod-card">
            <h3>إضافة حظر جديد</h3>
            <div class="amcod-field">
                <label>عنوان IP</label>
                <input type="text" name="block_ip_address" class="amcod-input-text" placeholder="مثال: 192.168.1.1" required>
            </div>
            <div class="amcod-field">
                <label>مدة الحظر (بالساعات)</label>
                <input type="number" name="block_duration" class="amcod-input-number" value="24">
            </div>
            <div style="margin-top: 20px; text-align: left;">
                <input type="submit" name="block_ip" class="button amcod-submit-btn" value="تنفيذ الحظر">
            </div>
        </div>
    </form>
    </div>
    <?php
}
add_action('woocommerce_checkout_process', function() {
    if (!class_exists('WC_Geolocation')) return;
    $ip = WC_Geolocation::get_ip_address();
    $blocked = get_option('amcod_blocked_ips', []);
    if (isset($blocked[$ip]) && $blocked[$ip] > time()) {
        wc_add_notice('تم حظر عنوان IP الخاص بك.', 'error');
    }
});

// --- صفحة Order Limits ---
function amcod_order_limit_settings_page() {
    if (isset($_POST['amcod_order_limit_submit'])) {
        update_option('amcod_order_limit_count', intval($_POST['amcod_order_limit_count']));
        update_option('amcod_order_limit_time', intval($_POST['amcod_order_limit_time']));
        echo '<div class="notice notice-success is-dismissible"><p>✅ تم حفظ إعدادات الحدود.</p></div>';
    }
    $count = get_option('amcod_order_limit_count', 0);
    $time = get_option('amcod_order_limit_time', 24);
    
    amcod_admin_header_and_styles('حدود الطلب', 'dashicons-filter', 'تحديد عدد الطلبات المسموح بها لكل مستخدم');
    ?>
    <form method="post">
        <div class="amcod-card">
            <h3>الإعدادات</h3>
            <div class="amcod-field">
                <label>أقصى عدد طلبات (0 لتعطيل الخاصية)</label>
                <input type="number" name="amcod_order_limit_count" class="amcod-input-number" value="<?php echo esc_attr($count); ?>">
            </div>
            <div class="amcod-field">
                <label>المدة الزمنية (بالساعات)</label>
                <input type="number" name="amcod_order_limit_time" class="amcod-input-number" value="<?php echo esc_attr($time); ?>">
            </div>
            <div style="margin-top: 20px; text-align: left;">
                <input type="submit" name="amcod_order_limit_submit" class="button amcod-submit-btn" value="حفظ الإعدادات">
            </div>
        </div>
    </form>
    </div>
    <?php
}

// --- صفحة Add to Cart ---
function amcod_add_to_cart_page() {
    if (isset($_POST['amcod_save_settings'])) {
        update_option('amcod_disable_original_add_to_cart', isset($_POST['amcod_disable_original_add_to_cart']) ? 'yes' : 'no');
        update_option('amcod_disable_form_add_to_cart', isset($_POST['amcod_disable_form_add_to_cart']) ? 'yes' : 'no');
        echo '<div class="notice notice-success is-dismissible"><p>✅ تم حفظ الإعدادات.</p></div>';
    }
    $disabled_original = get_option('amcod_disable_original_add_to_cart', 'no');
    $disabled_form = get_option('amcod_disable_form_add_to_cart', 'no');
    
    amcod_admin_header_and_styles('إعدادات زر الإضافة للسلة', 'dashicons-cart', 'التحكم في ظهور أزرار الشراء');
    ?>
    <form method="post">
        <div class="amcod-card">
            <h3>التحكم في الأزرار</h3>
            <div class="amcod-field">
                <label>إخفاء زر "أضف للسلة" الأصلي للقالب</label>
                <div class="amcod-checkbox-wrapper">
                    <input type="checkbox" name="amcod_disable_original_add_to_cart" value="yes" <?php checked($disabled_original, 'yes'); ?>>
                </div>
            </div>
            <div class="amcod-field">
                <label>إخفاء زر "أضف للسلة" الخاص بالإضافة</label>
                <div class="amcod-checkbox-wrapper">
                    <input type="checkbox" name="amcod_disable_form_add_to_cart" value="yes" <?php checked($disabled_form, 'yes'); ?>>
                </div>
            </div>
            <div style="margin-top: 20px; text-align: left;">
                <input type="submit" name="amcod_save_settings" class="button amcod-submit-btn" value="حفظ الإعدادات">
            </div>
        </div>
    </form>
    </div>
    <?php
}

// --- صفحة Disable Checkout Form ---
function amcod_disable_checkout_form_page() {
    if (isset($_POST['amcod_disable_form_submit'])) {
        update_option('amcod_disable_checkout_form', isset($_POST['amcod_disable_checkout_form']) ? 'yes' : 'no');
        echo '<div class="notice notice-success is-dismissible"><p>✅ تم حفظ الإعدادات.</p></div>';
    }
    $disabled = get_option('amcod_disable_checkout_form', 'no');
    
    amcod_admin_header_and_styles('تعطيل النموذج', 'dashicons-hidden', 'إخفاء نموذج الدفع السريع مؤقتاً');
    ?>
    <form method="post">
        <div class="amcod-card">
            <h3>حالة النموذج</h3>
            <div class="amcod-field">
                <label>تعطيل نموذج الدفع السريع AM COD</label>
                <div class="amcod-checkbox-wrapper">
                    <input type="checkbox" name="amcod_disable_checkout_form" value="yes" <?php checked($disabled, 'yes'); ?>>
                </div>
            </div>
            <div style="margin-top: 20px; text-align: left;">
                <input type="submit" name="amcod_disable_form_submit" class="button amcod-submit-btn" value="حفظ الحالة">
            </div>
        </div>
    </form>
    </div>
    <?php
}

// --- صفحة Language ---
function amcod_language_page() {
    if (isset($_POST['amcod_save_lang'])) {
        update_option('amcod_text_info', sanitize_text_field($_POST['amcod_text_info']));
        update_option('amcod_billing_first_name_placeholder', sanitize_text_field($_POST['amcod_billing_first_name_placeholder']));
        update_option('amcod_billing_phone_placeholder', sanitize_text_field($_POST['amcod_billing_phone_placeholder']));
        update_option('amcod_text_submit', sanitize_text_field($_POST['amcod_text_submit']));
        echo '<div class="notice notice-success is-dismissible"><p>✅ تم حفظ النصوص.</p></div>';
    }
    
    amcod_admin_header_and_styles('تخصيص النصوص', 'dashicons-translation', 'تغيير النصوص الظاهرة في النموذج');
    ?>
    <form method="post">
        <div class="amcod-card">
            <h3>النصوص والترجمة</h3>
            <div class="amcod-field">
                <label>النص المتحرك (أعلى النموذج)</label>
                <input type="text" name="amcod_text_info" class="amcod-input-text" value="<?php echo esc_attr(get_option('amcod_text_info', 'للطلب أضف معلوماتك في الأسفل 👇')); ?>">
            </div>
            <div class="amcod-field">
                <label>نص حقل الاسم</label>
                <input type="text" name="amcod_billing_first_name_placeholder" class="amcod-input-text" value="<?php echo esc_attr(get_option('amcod_billing_first_name_placeholder', 'الاسم الكامل')); ?>">
            </div>
            <div class="amcod-field">
                <label>نص حقل الهاتف</label>
                <input type="text" name="amcod_billing_phone_placeholder" class="amcod-input-text" value="<?php echo esc_attr(get_option('amcod_billing_phone_placeholder', 'رقم الهاتف')); ?>">
            </div>
            <div class="amcod-field">
                <label>نص زر الطلب</label>
                <input type="text" name="amcod_text_submit" class="amcod-input-text" value="<?php echo esc_attr(get_option('amcod_text_submit', 'اطلب الآن')); ?>">
            </div>
            <div style="margin-top: 20px; text-align: left;">
                <input type="submit" name="amcod_save_lang" class="button amcod-submit-btn" value="حفظ النصوص">
            </div>
        </div>
    </form>
    </div>
    <?php
}

// --- صفحة Checkout Animations ---
function amcod_checkout_animations_page() {
    if (isset($_POST['amcod_save_animations'])) {
        update_option('amcod_enable_animation', isset($_POST['enable_animation']) ? 'yes' : 'no');
        update_option('amcod_animation_type', sanitize_text_field($_POST['animation_type']));
        echo '<div class="notice notice-success is-dismissible"><p>✅ تم حفظ إعدادات الحركة.</p></div>';
    }
    $enabled = get_option('amcod_enable_animation', 'no');
    $selected_animation = get_option('amcod_animation_type', 'none');
    
    amcod_admin_header_and_styles('حركة زر الطلب', 'dashicons-controls-play', 'إضافة تأثيرات حركية لزر الطلب لجذب الانتباه');
    ?>
    <form method="post">
        <div class="amcod-card">
            <h3>إعدادات الأنيميشن</h3>
            <div class="amcod-field">
                <label>تفعيل الحركة على الزر</label>
                <div class="amcod-checkbox-wrapper">
                    <input type="checkbox" name="enable_animation" value="yes" <?php checked($enabled, 'yes'); ?>>
                </div>
            </div>
            <div class="amcod-field">
                <label>نوع الحركة</label>
                <select name="animation_type" class="amcod-select">
                    <option value="none" <?php selected($selected_animation, 'none'); ?>>بدون</option>
                    <option value="shake" <?php selected($selected_animation, 'shake'); ?>>هزة (Shake)</option>
                    <option value="bounce" <?php selected($selected_animation, 'bounce'); ?>>قفز (Bounce)</option>
                    <option value="pulse" <?php selected($selected_animation, 'pulse'); ?>>نبض (Pulse)</option>
                    <option value="wiggle" <?php selected($selected_animation, 'wiggle'); ?>>تأرجح (Wiggle)</option>
                </select>
            </div>
            <div style="margin-top: 20px; text-align: left;">
                <input type="submit" name="amcod_save_animations" class="button amcod-submit-btn" value="حفظ الإعدادات">
            </div>
        </div>
    </form>
    </div>
    <?php
}
add_action('wp_head', 'amcod_add_checkout_button_animation');
function amcod_add_checkout_button_animation() {
    if (!is_product()) return;
    if (get_option('amcod_enable_animation', 'no') !== 'yes') return;
    $animation = get_option('amcod_animation_type', 'none');
    if ($animation === 'none') return;
    ?>
    <style>
        @keyframes shake { 0%, 100% { transform: translateX(0); } 25% { transform: translateX(-5px); } 50% { transform: translateX(5px); } 75% { transform: translateX(-5px); } }
        @keyframes bounce { 0%, 100% { transform: translateY(0); } 50% { transform: translateY(-10px); } }
        @keyframes pulse { 0% { transform: scale(1); } 50% { transform: scale(1.1); } 100% { transform: scale(1); } }
        @keyframes wiggle { 0%, 100% { transform: rotate(0); } 25% { transform: rotate(-3deg); } 50% { transform: rotate(3deg); } 75% { transform: rotate(-3deg); } }
        #custom-checkout-form button[type="submit"] { animation: <?php echo esc_html($animation); ?> 1.5s infinite ease-in-out; }
    </style>
    <?php
}

// --- صفحة Field Editor ---
function amcod_field_editor_page() {
    if (isset($_POST['amcod_save_fields'])) {
        update_option('amcod_disable_city_field', isset($_POST['amcod_disable_city_field']) ? 'yes' : 'no');
        update_option('amcod_field_editor_email_enable', isset($_POST['amcod_field_editor_email_enable']) ? 'yes' : 'no');
        update_option('amcod_field_editor_note_enable', isset($_POST['amcod_field_editor_note_enable']) ? 'yes' : 'no');
        echo '<div class="notice notice-success is-dismissible"><p>✅ تم حفظ إعدادات الحقول.</p></div>';
    }
    
    amcod_admin_header_and_styles('محرر الحقول', 'dashicons-editor-table', 'التحكم في الحقول التي تظهر للعميل');
    ?>
    <form method="post">
        <div class="amcod-card">
            <h3>إظهار / إخفاء الحقول</h3>
            <div class="amcod-field">
                <label>تعطيل حقل "البلدية"</label>
                <div class="amcod-checkbox-wrapper">
                    <input type="checkbox" name="amcod_disable_city_field" value="yes" <?php checked(get_option('amcod_disable_city_field', 'no'), 'yes'); ?>>
                </div>
            </div>
            <div class="amcod-field">
                <label>تفعيل حقل "البريد الإلكتروني"</label>
                <div class="amcod-checkbox-wrapper">
                    <input type="checkbox" name="amcod_field_editor_email_enable" value="yes" <?php checked(get_option('amcod_field_editor_email_enable', 'no'), 'yes'); ?>>
                </div>
            </div>
            <div class="amcod-field">
                <label>تفعيل حقل "ملاحظات الطلب"</label>
                <div class="amcod-checkbox-wrapper">
                    <input type="checkbox" name="amcod_field_editor_note_enable" value="yes" <?php checked(get_option('amcod_field_editor_note_enable', 'no'), 'yes'); ?>>
                </div>
            </div>
            <div style="margin-top: 20px; text-align: left;">
                <input type="submit" name="amcod_save_fields" class="button amcod-submit-btn" value="حفظ التغييرات">
            </div>
        </div>
    </form>
    </div>
    <?php
}

// --- صفحة WhatsApp ---
function amcod_whatsapp_button_page() {
    if (isset($_POST['amcod_save_whatsapp'])) {
        update_option('amcod_whatsapp_enabled', isset($_POST['amcod_whatsapp_enabled']) ? 'yes' : 'no');
        update_option('amcod_whatsapp_number', sanitize_text_field($_POST['amcod_whatsapp_number']));
        update_option('amcod_whatsapp_template', wp_kses_post($_POST['amcod_whatsapp_template']));
        echo '<div class="notice notice-success is-dismissible"><p>✅ تم حفظ إعدادات واتساب.</p></div>';
    }
    $enabled = get_option('amcod_whatsapp_enabled', 'no');
    $number = get_option('amcod_whatsapp_number', '');
    $template = get_option('amcod_whatsapp_template', "مرحباً، أريد الطلب:\n\n{product_name}\n💰 السعر: {product_price} {currency_symbol}\n");
    
    amcod_admin_header_and_styles('إعدادات واتساب', 'dashicons-whatsapp', 'تفعيل زر الطلب المباشر عبر واتساب');
    ?>
    <form method="post">
        <div class="amcod-card">
            <h3>بيانات واتساب</h3>
            <div class="amcod-field">
                <label>تفعيل الزر</label>
                <div class="amcod-checkbox-wrapper">
                    <input type="checkbox" name="amcod_whatsapp_enabled" value="yes" <?php checked($enabled, 'yes'); ?>>
                </div>
            </div>
            <div class="amcod-field">
                <label>رقم الهاتف (مع الرمز الدولي بدون +)</label>
                <input type="text" name="amcod_whatsapp_number" class="amcod-input-text" value="<?php echo esc_attr($number); ?>" placeholder="مثال: 213555555555">
            </div>
            <div class="amcod-field" style="align-items: flex-start;">
                <label>قالب الرسالة</label>
                <textarea name="amcod_whatsapp_template" class="amcod-textarea" rows="5"><?php echo esc_textarea($template); ?></textarea>
            </div>
            <div style="margin-top: 20px; text-align: left;">
                <input type="submit" name="amcod_save_whatsapp" class="button amcod-submit-btn" value="حفظ الإعدادات">
            </div>
        </div>
    </form>
    </div>
    <?php
}

// --- صفحة Variation Swatches ---
function amcod_variation_swatches_page() {
    if (isset($_POST['amcod_save_swatches'])) {
        update_option('amcod_variation_swatches_global_disable', $_POST['amcod_variation_swatches_global_disable']);
        echo '<div class="notice notice-success is-dismissible"><p>✅ تم حفظ الإعدادات.</p></div>';
    }
    $global_disable = get_option('amcod_variation_swatches_global_disable', 'enable');
    
    amcod_admin_header_and_styles('خيارات المتغيرات', 'dashicons-images-alt2', 'التحكم في طريقة عرض خيارات المنتج (ألوان، مقاسات)');
    ?>
    <form method="post">
        <div class="amcod-card">
            <h3>نمط العرض</h3>
            <div class="amcod-field">
                <label>عرض المتغيرات كأزرار (Swatches)</label>
                <div>
                    <label style="margin-left: 15px;"><input type="radio" name="amcod_variation_swatches_global_disable" value="enable" <?php checked($global_disable, 'enable'); ?>> تفعيل (مربعات أنيقة)</label>
                    <label><input type="radio" name="amcod_variation_swatches_global_disable" value="disable" <?php checked($global_disable, 'disable'); ?>> تعطيل (قائمة عادية)</label>
                </div>
            </div>
            <div style="margin-top: 20px; text-align: left;">
                <input type="submit" name="amcod_save_swatches" class="button amcod-submit-btn" value="حفظ الإعدادات">
            </div>
        </div>
    </form>
    </div>
    <?php
}

// تحميل Color Picker
add_action('admin_enqueue_scripts', function($hook){
    wp_enqueue_style('wp-color-picker');
    wp_enqueue_script('wp-color-picker');
});
?>